const gpioControl = require("../system-controller/gpioController");
const delay = require("delay");

var leds = {
    1: true,
    2: true,
    3: true,
    4: true
}

var wave = true;

async function blink(led, duration) {
    while (leds[led]) {
        gpioControl.setLed(led, 1, 1, 0);
        await delay(duration);
        gpioControl.setLed(led, 0, 1, 0);
        await delay(duration);
    }
    return;
}

async function waveLed() {
    while (wave) {
        gpioControl.setLed(1, 1, 1, 0);
        gpioControl.setLed(2, 0, 1, 0);
        gpioControl.setLed(3, 0, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 0, 1, 0);
        gpioControl.setLed(2, 1, 1, 0);
        gpioControl.setLed(3, 0, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 0, 1, 0);
        gpioControl.setLed(2, 0, 1, 0);
        gpioControl.setLed(3, 1, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 0, 1, 0);
        gpioControl.setLed(2, 0, 1, 0);
        gpioControl.setLed(3, 0, 1, 0);
        gpioControl.setLed(4, 1, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 0, 1, 0);
        gpioControl.setLed(2, 0, 1, 0);
        gpioControl.setLed(3, 1, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 0, 1, 0);
        gpioControl.setLed(2, 1, 1, 0);
        gpioControl.setLed(3, 0, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(100);
        gpioControl.setLed(1, 1, 1, 0);
        gpioControl.setLed(2, 0, 1, 0);
        gpioControl.setLed(3, 0, 1, 0);
        gpioControl.setLed(4, 0, 1, 0);
        await delay(50);
    }
    gpioControl.setLed(1, 0, 1, 0);
    gpioControl.setLed(2, 0, 1, 0);
    gpioControl.setLed(3, 0, 1, 0);
    gpioControl.setLed(4, 0, 1, 0);
    return;
}

async function ledOn(led, timer) {
    await delay(timer);
    leds[led] = true;
    wave = false;
    await delay(500);
    gpioControl.setLed(led, 1, 1, 0);
    return;
}

async function ledOff(led, timer) {
    await delay(timer);
    leds[led] = false;
    wave = false;
    await delay(500);
    gpioControl.setLed(led, 0, 1, 0);
    return;
}

module.exports = {
    blink,
    waveLed,
    ledOn,
    ledOff
}