const Gpio = require("onoff").Gpio;
const delay = require("delay");

const moteReset = new Gpio(60, "out");

moteReset.write(1, function(err, value) {
  if (err) {
    console.log("Momote reset pin error: ", err);
  } else {
    //console.log("LED :", value);
  }
});

const led = {
  led1: new Gpio(113, "out"),
  led2: new Gpio(152, "out"),
  led3: new Gpio(155, "out"),
  led4: new Gpio(19, "out")
};

const button1 = new Gpio(138, "in", "both");
const button2 = new Gpio(137, "in", "both");
const button3 = new Gpio(153, "in", "both");
/*
button1.watch(function (err, value) {
    console.log("### RESET button")
    if (err) {
        console.log("RESET BUTTON ERROR", err);
    } else {
        console.log("RESET button: ", value);
    }
});
button2.watch(function (err, value) {
    console.log("### Watch switch:")
    if (err) {
        console.log("Switch 2 ERROR", err);
    } else {
        console.log("Switch 2 Value:", value);
    }
});
button3.watch(function (err, value) {
    console.log("### Watch switch:")
    if (err) {
        console.log("Switch 3 ERROR", err);
    } else {
        console.log("Switch 3 Value:", value);
    }
});
*/
function setGatewayLEDS(aLed, status, interval, timeToDie) {
  let blinkInterval;
  let actLed = "led";
  actLed += aLed;

  switch (interval) {
    case 0:
      led[actLed].write(parseInt(status), function(err, value) {
        if (err) {
          console.log("LED ERROR -", err);
        } else {
          //console.log("LED :", value);
        }
      });
      break;
    case 1:
      led[actLed].write(parseInt(status), function(err, value) {
        if (err) {
          console.log("LED ERROR -", err);
        } else {
          //console.log("LED :", value);
        }
      });
      break;
    default:
      let ledStatus = status;
      timeToDie = timeToDie * 2;
      blinkInterval = setInterval(() => {
        if (ledStatus == 1) {
          led[actLed].write(parseInt(0), function(err, value) {
            if (err) {
              console.log("LED ERROR -", err);
            } else {
              // console.log("LED :", value);
            }
          });
          timeToDie--;
          ledStatus = 0;
        } else if (ledStatus == 0) {
          led[actLed].write(parseInt(1), function(err, value) {
            if (err) {
              console.log("LED ERROR -", err);
            } else {
              // console.log("LED :", value);
            }
          });
          timeToDie--;
          ledStatus = 1;
        }
        if (timeToDie == 0) clearInterval(blinkInterval);
      }, interval);
      if (timeToDie == 0) clearInterval(blinkInterval);
      break;
  }
}

function gatewayInitLEDS() {}

function imageDownloadLEDS() {
  let pattern = [[0, 1000], [1, 1000], [2, 1000], [3, 1000]];
  blinkLEDS(pattern);
}

async function blinkLEDS(pattern) {
  let actLed = "led";
  for (const blink of pattern) {
    actLed += blink[0]+"";
    led[actLed].write(parseInt(1), function(err, value) {
      if (err) {
        console.log("LED ERROR -", err);
      } else {
        //console.log("LED :", value);
      }
    });
    await delay(blink[1]);
  }
}

module.exports = {
  //imageDownloadLEDS,
  //gatewayInitLEDS,
  setLed: setGatewayLEDS,
  button1,
  button2,
  button3
};
