var fs = require('fs');
var FileName = '';
var IMAGE_STATUS = Object.freeze ({"BROKE": 0, "STABLE": 1, "NEW":2, "EMPTY":3});

var imageStatus = {
    currentImage: "",
    lastImage: "",
    imageStatus: IMAGE_STATUS.EMPTY
}
function saveToFile () {
    fs.writeFile(FileName, JSON.stringify(imageStatus), "utf8",
        (err) => {
            if (err) throw err;
        });
}

function loadFromFile (callback) {
    fs.readFile(FileName, 'utf8', 
    (err, data) => {
        if (err){
            console.log(err);
        } else {
            imageStatus = JSON.parse(data);
        }
        callback(err);
    });
}

function init (fileName, callback) {
    FileName = fileName;
    loadFromFile((err) => {
        if (err) {
            // console.log (err);
            if (err.errno == -2) {
                saveToFile();
            }
        }
        callback(err);
        return module;
    });
}

function getCurrentImage () {
    return {currentImage: imageStatus.currentImage,
        status: imageStatus.imageStatus};
}

function setImageStatus (imgStat) {
        imageStatus.imageStatus = imgStat;
        saveToFile();
}

function setCurrentImage (filename) {
    imageStatus.lastImage = imageStatus.currentImage;
    imageStatus.currentImage = filename;
    imageStatus.imageStatus = IMAGE_STATUS.NEW;
    saveToFile();
}

module.exports = {
    init, getCurrentImage, setImageStatus, setCurrentImage, IMAGE_STATUS
}