//!TODO Apagar imagem anterior
var fs = require('fs');
var ftp = require('./view/ftp');
// var gpio = require('./view/gpio');
var image = require('./model/imageModel.js');
var tar = require('tar');
var ENV = 'PIXEL';
var DEFAULT_FTP_VALUES = ftp.ftp_getDefault(ENV);
var filePaths = require('./model/appFileModel.js').get_paths(ENV);

//Decrypt module
var dec = require('./model/decypher');

function untar(fileName, targetDir) {
    console.log('untar file: ' + fileName + ' to ' + targetDir);
    fs.createReadStream(fileName).pipe(tar.x({
        C: targetDir, // alias for cwd:'some-dir', also ok
        onwarn: function (message, data) { console.log(message) },
    })).once('close', function () {
        console.log('Ready to launch!');
        //     var exec = require('child_process').exec;
        // exec('cd /tmp/ecomfort-gateway && npm start', function callback(error, stdout, stderr){
        //     // result
        // });
    });
}


function launchFile() {
    //Verify if image is broke
    if (image.getCurrentImage().status == image.IMAGE_STATUS.BROKE) {
        console.log('Image is marked as broke. Restoring image!')
        fs.access(filePaths.encryptedStableFileName,
            fs.constants.R_OK,
            (err) => {
                if (err) {
                    console.log('Stable image not found. Should load GoldenImage');
                    fs.createReadStream(filePaths.goldenImage).pipe(
                        fs.createWriteStream(filePaths.encryptedCurFileName).once('close',
                            () => {
                                image.setImageStatus(image.IMAGE_STATUS.NEW);
                                decrypt_and_run();
                            })
                    );
                } else {
                    //Copy stable to current and launch and clear stable
                    console.log('Copying stable to current...')
                    fs.createReadStream(filePaths.encryptedStableFileName).pipe(
                        fs.createWriteStream(filePaths.encryptedCurFileName).once('close',
                            () => {
                                image.setImageStatus(image.IMAGE_STATUS.NEW);
                                console.log('Deleting stable...')
                                fs.unlink(filePaths.encryptedStableFileName);
                                decrypt_and_run();
                            })
                    );
                }
            });
    } else {
        image.setImageStatus(image.IMAGE_STATUS.BROKE);
        decrypt_and_run();
    }
}

function decrypt_and_run() {
    //Verify if file exists
   // gpio.ledOff(1, 50);
   // gpio.blink(1, 100);
   // gpio.blink(2, 100);
   // gpio.blink(3, 100);
   // gpio.blink(4, 100);
    console.log("Decrypt: Verifying if \"%s\" exists:", filePaths.encryptedCurFileName);
    fs.access(filePaths.encryptedCurFileName,
        fs.constants.R_OK,
        (err) => {
            if (err) {
                console.log('File does not exist. Exiting.');
                process.exit(1);
            } else {
                //Decrypt and untar file
                console.log("Decrypting");
                dec.decrypt_openSSL(filePaths.encryptedCurFileName,
                    // dec.decrypt(filePaths.encryptedCurFileName,
                    filePaths.compressedFileName,
                    (fileName) => {
                        console.log("decompressing");
                        untar(filePaths.compressedFileName,
                            filePaths.runPath);
                    }
                );
            }
        });
}
//Parameters parser
if (process.argv.length == 2) {
    image.init(filePaths.imageRegister, () => {
        if (image.getCurrentImage().status == image.IMAGE_STATUS.EMPTY) {
            //Download initial version
           // gpio.waveLed();
            console.log("Downloading initial file: %s", filePaths.initialImageFileName);
            ftp.ftp_get(DEFAULT_FTP_VALUES.host,
                DEFAULT_FTP_VALUES.initialImageFileName,
                filePaths.goldenImage,
                DEFAULT_FTP_VALUES.user,
                DEFAULT_FTP_VALUES.password,
                (fileName) => {
                    console.log("File %s successful downloaded", fileName);
                    image.setImageStatus(image.IMAGE_STATUS.BROKE);
                    launchFile();
                });
        } else {
            launchFile();
        }
    });
} else {
    //Download a new version
    // gpio.waveLed();
    outputFile = fs.createWriteStream(filePaths.encryptedStableFileName);
    fs.createReadStream(filePaths.encryptedCurFileName).pipe(outputFile);
    outputFile.once('close', () => {
        image.init(filePaths.imageRegister, () => {
            console.log("Downloading file %s", process.argv[2]);
            ftp.ftp_get(DEFAULT_FTP_VALUES.host,
                process.argv[2],
                filePaths.encryptedCurFileName,
                DEFAULT_FTP_VALUES.user,
                DEFAULT_FTP_VALUES.password,
                (fileName) => {
                    console.log("File %s successful downloaded", fileName);
                    image.setImageStatus(image.IMAGE_STATUS.NEW);
                    launchFile();
                });
        });
    });
}