const devices = [{
    _id: '5a293e7188ba3a5d8f202b1b',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 1',
    mac_address: '3A:34:DA:FA:3A:34:DA:F4'
},
{
    _id: '5a293e7d88ba3a5d8f202b1c',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 2',
    mac_address: '3A:34:DA:FA:3A:34:DA:F0'
},
{
    _id: '5a293e8488ba3a5d8f202b1d',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 3',
    mac_address: '3A:34:DA:FA:3A:34:DA:F1'
},
{
    _id: '5a293e8f88ba3a5d8f202b1e',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 4',
    mac_address: '3A:34:DA:FA:3A:34:DA:F2'
},
{
    _id: '5a293ea488ba3a5d8f202b1f',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 5',
    mac_address: '3A:34:DA:FA:3A:34:DA:F5'
},
{
    _id: '5a293eaa88ba3a5d8f202b20',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 6',
    mac_address: '3A:34:DA:FA:3A:34:DA:F6'
},
{
    _id: '5a293eb288ba3a5d8f202b21',
    status: 'ON',
    type: undefined,
    create: '2017-12-07T13:12:44.085Z',
    endpointId: '4',
    last_modification: undefined,
    name: 'Sensor Luminosidade 7',
    mac_address: '3A:34:DA:FA:3A:34:DA:F7'
}];

let environments = {
    _id: '5a293e5588ba3a5d8f202b1a',
    environments: [
        {
            name: 'sala',
            _id: '5a29442c030d4a64d2e81782',
            devices: [
                {
                    _id: "5a293e7188ba3a5d8f202b1b"
                },
                {
                    _id: "5a293e7d88ba3a5d8f202b1c"
                }
            ],
            last_modification: '2017 - 12 - 07T13: 37: 45.276Z',
            create: '2017 - 12 - 07T13: 37: 45.276Z'
        }]
}

const transformDevices = (device => {
    return {
        endpointId: device.endpointId,
        mac_address: device.mac_address,
        deviceId: device.deviceId,
        name: device.name,
        _id: device._id,
        create: device.create,
        status: device.status
    }
})


environments.environments.map(environment => {
    let modifiedDevices = environment.devices.filter(device => {
        return devices.find(item => item._id === device._id);
    }).map(transformDevices);

    console.log("Data:",modifiedDevices)

    return {
        name: 'sala',
        _id: '5a29442c030d4a64d2e81782',
        devices: [{
            _id: "5a293e7188ba3a5d8f202b1b"
        },
        {
            _id: "5a293e7d88ba3a5d8f202b1c"
        }],
        last_modification: '2017 - 12 - 07T13: 37: 45.276Z',
        create: '2017 - 12 - 07T13: 37: 45.276Z'

    }

});


//
//
//