'use strict';
//Token valido por 1h
var token = undefined;

const gateway = {
    "_id": null,
    "mac_address": "80:F1:6F:F8:BA:AA",
    "key": "04e0f34e-b699-4532-a5a8-ecf206c5a7AA",
    "status": "HABILIDADO"
}

describe('Controller gateway', () => {

    it('Efetua login', (done) => {
        request
            .post('/login')
            .send({ email: 'marlon@pixelti.com', password: 'Pixelti@1700' })
            .set('x-access-token', 'foobar')
            .set('Accept', 'application/json')
            .end((err, res) => {
                token = res.body.token;
                expect(res.body).have.property('token')
                done(err);
            });
    })

    it('findGatewayInToken retorna um gateway', (done) => {
        request.get(`/gateways`)
            .set('x-access-token', token)
            .end((err, res) => {
                gateway._id = res.body.gateway._id;
                expect(res.body).have.property('gateway');
                done(err);
            });

    });

    it('deleteGateway deleta o gateway caso exista!', (done) => {

        request.delete('/gateways').
            set('x-access-token', token).
            set('Accept', 'application/json').
            send({ id: gateway._id }).
            end((err, res) => {
                expect(res.status).to.be.eql(200);
                done(err);
            });
    });

    it('createNewGateway cria um registro', (done) => {
        gateway._id = '59d4e200fc08bc2e42b2dc5e';
        request.post('/gateways').
            set('x-access-token', token).
            send(gateway).
            end((err, res) => {
                expect(res.body).have.property('gateway').
                    have.property('mac_address');
                done(err);
            });
    });

    it('createNewGateway erro ao criar registro!', (done) => {
        request.post('/gateways').
            set('x-access-token', token).
            set('Accept', 'application/json').
            send(gateway).
            end((err, res) => {
                expect(res.body).have.property('message');
                done(err);
            });
    });

    it('updateGateway restorna status 200!', (done) => {
        request.put('/gateways').
            set('x-access-token', token).
            set('Accept', 'application/json').
            send(gateway).
            end((err, res) => {
                expect(res.status).to.be.eql(200);
                done(err);
            });
    });

    it('updateGateway restorna mensagem de erro!', (done) => {
        gateway._id = '';
        request.put('/gateways').
            set('x-access-token', token).
            set('Accept', 'application/json').
            send(gateway).
            end((err, res) => {
                expect(res.body).have.property('message');
                done(err);
            });
    });



})
