'use strict';

const router = require('./router.main');
const controller = require('../controllers/user.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.post('/users', authService.authorize, controller.createUser);
    
    router.put('/users/:userId', authService.authorize, controller.updateUser);
    
    router.delete('/users/:userId', authService.authorize, controller.deleteUser);
        
    router.get('/users/:userId', authService.authorize, controller.findUserById);

    router.get('/users/email/:email', authService.authorize, controller.findUserByEmail);

    router.get('/users/', authService.authorize, controller.findUsers);

    return router;
}
