'use strict';

const router = require('./router.main');
const controller = require('../controllers/scenario.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.get('/scenarios', authService.authorize, controller.listScenarios);
        
    router.get('/scenarios/:scenarioId', authService.authorize, controller.listScenarioById);

    router.post('/scenarios', authService.authorize, controller.createScenario);   
    
    router.put('/scenarios/:scenarioId', authService.authorize, controller.updateScenario); 
    
    router.delete('/scenarios/:scenarioId', authService.authorize, controller.deleteScenario);    

    return router;
}