'use strict';

const router = require('./router.main');
const controller = require('../controllers/rule.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.get('/rules', authService.authorize, controller.listRules);

    router.get('/rules/apply', authService.authorize, controller.applyRulesPolitics);
    router.get('/rules/run', authService.authorize, controller.runRules);
    router.get('/rules/start', authService.authorize, controller.startRules);
    router.get('/rules/stop', authService.authorize, controller.stopRules);
        
    router.get('/rules/:ruleId', authService.authorize, controller.listRuleById);

    router.post('/rules', authService.authorize, controller.createRule);  
    
    router.put('/rules/:ruleId', authService.authorize, controller.updateRule); 
    
    router.delete('/rules/:ruleId', authService.authorize, controller.deleteRule);              

    return router;
}