'use strict';

const router = require('./router.main');
const controller = require('../controllers/log.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.get('/logs', authService.authorize, controller.listLogs);
        
    router.get('/logs/:logId', authService.authorize, controller.listLogById);

    router.post('/logs', authService.authorize, controller.createLog);   
    
    router.delete('/logs/:logId', authService.authorize, controller.deleteLog);    

    return router;
}