"use strict";

const router = require("./router.main");
const authServices = require("../security/auth.services");
const gatewayController = require("../controllers/gateway.controller");

module.exports = () => {
  router.get("/gateway", /*authServices.authorize,*/ gatewayController.listGateway);

  router.post("/gateway", authServices.authorize, gatewayController.createGateway);

  router.put("/gateway", authServices.authorize, gatewayController.updateGatewaySerial);

  router.delete("/gateway/:gatewayId", authServices.authorize, gatewayController.deleteGateway);

  return router;
};
