'use strict';

const router = require('./router.main');
const controller = require('../controllers/environment.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.get('/environments', authService.authorize, controller.listEnvironments);
        
    router.get('/environments/:environmentId', authService.authorize, controller.listEnvironmentById);

    router.post('/environments', authService.authorize, controller.createEnvironment);
    
    router.put('/environments/:environmentId', authService.authorize, controller.updateEnvironment); 
    
    router.delete('/environments/:environmentId', authService.authorize, controller.deleteEnvironment);       

    return router;
}