'use strict';

const router = require('./router.main');
const controller = require('../controllers/device.controller');
const authService = require('../security/auth.services');

module.exports = () => {

    router.get('/devices', authService.authorize, controller.listDevices);
        
    router.get('/devices/:deviceId', authService.authorize, controller.listDeviceById);

    router.get('/devices/ieeeAddr/:devIeeeAddr', authService.authorize, controller.listDeviceByIeeeAddr);

    router.get('/devices/environment/:environmentId', authService.authorize, controller.listDevicesByEnvironment);

    router.post('/devices', authService.authorize, controller.createDevice);

    router.post('/devices/addNewBlockedUser/:deviceId', authService.authorize, controller.addNewBlockedUser);

    router.post('/devices/removeBlockedUser/:deviceId', authService.authorize, controller.removeBlockedUser);
    
    router.put('/devices/:deviceId', authService.authorize, controller.updateDevice);  

    //router.delete('/devices/:deviceId', authService.authorize, controller.deleteDevice);

    router.delete('/devices/all', authService.authorize, controller.deleteAllDevices);

    router.delete('/devices/ieeeAddr/:ieeeAddr', authService.authorize, controller.deleteDeviceByIeeeAddr);

    return router;
}