'use strict';


const router = require('./router.main');
const authServices = require('../security/auth.services');
const accountController = require('../controllers/account.controller');

module.exports = () => {

    router.post('/account/register', accountController.createAccount);

    router.post('/account/login', accountController.authUserByEmailAndPassword);

    router.post('/account/verify-token', authServices.authorize, accountController.verifyIfTokenIsValid);

    return router;
}
