"use strict";

const Users = require("../user.model");
const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");

exports.findUserById = async data => await Users.findOne({ _id: data.userId });

exports.findUserByEmail = async data =>
  await Users.findOne({ email: data.email });

exports.findUsers = async data => await Users.find();

exports.createUser = async data => {
  let user = await Users.create(data);
  await user.save();
  return user;
};

exports.updateUser = async (param, data) => {
  let user = await Users.findOneAndUpdate({ _id: param.userId }, data);
  user.lastUpdate = Date.now();
  await user.save();
  return user;
};

exports.deleteUser = async param => {
  return await Users.findOneAndDelete({ _id: param.userId });
};
