"use strict";

const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");
const Scenario = require("../scenario.model");

exports.listScenarioById = async data =>
  await Scenario.findOne({ scenarioId: data.scenarioId });

exports.listScenarios = async data => {
  let scenarios = await Scenario.find();
  return scenarios;
};

exports.createScenario = async data => {
  let scenario = await Scenario.create(data);
  await scenario.save();
  return scenario;
};

exports.updateScenario = async (param, data) => {
  let scenario = await Scenario.findOneAndUpdate(
    { scenarioId: param.scenarioId },
    data
  );
  scenario.lastUpdate = Date.now();
  await scenario.save();
  return scenario;
};

exports.deleteScenario = async param => {
  return await Scenario.findOneAndDelete({ scenarioId: param.scenarioId });
};
