"use strict";

const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");
const Rule = require("../rule.model");
var _ = require("lodash");


exports.listRuleById = async data => await Rule.findOne({ ruleId: data.ruleId });

exports.listRules = async data => {
  let rules = await Rule.find();
  return rules;
};

exports.createRule = async data => {
  let rule = await Rule.create(data);
  await rule.save();
  return rule;
};

exports.updateRule = async (param, data) => {
  let rule = await Rule.findOneAndUpdate({ ruleId: param.ruleId }, data);
  rule.lastUpdate = Date.now();
  await rule.save();
  return rule;
};

exports.deleteRule = async param => {
  await inMemoryDb.remove({ ruleId: param.ruleId });
  return await Rule.findOneAndDelete({ ruleId: param.ruleId });
};
