"use strict";

const Gateway = require("../gateway.model");

exports.listGateway = () => Gateway.find();

exports.createGateway = async data => {
  var gateway = await Gateway.create(data);
  await gateway.save();
  return gateway;
};

exports.updateGateway = async (params, data) => {
  var gateway = await Gateway.findOneAndUpdate(
    { _id: params.gatewayId },
    data,
    { multi: false },
    function(err, numReplaced) {}
  );
  gateway.lastUpdate = Date.now();
  await gateway.save();
  return gateway;
};

exports.updateGatewaySerial = async (data) => {
  var gateway = await Gateway.findOneAndUpdate(
    { status: "inactive" },
    data,
    { multi: false },
    function (err, numReplaced) { }
  );
  gateway.lastUpdate = Date.now();
  await gateway.save();
  console.log(chalk.green("[nedb-gateway] [update] " + gatewayId + ": " + JSON.stringify(data)));
  return gateway;
};

exports.deleteGateway = async param => {
  return await Gateway.findOneAndDelete({ _id: param.gatewayId });
};
