"use strict";

const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");
const Environment = require("../environment.model");

exports.listEnvironmentById = async data =>
  await Environment.findOne({ environmentId: data.environmentId });

exports.listEnvironments = async data => {
  let environments = await Environment.find();
  return environments;
};

exports.createEnvironment = async data => {
  let environment = await Environment.create(data);
  await environment.save();
  return environment;
};

exports.updateEnvironment = async (param, data) => {
  let environment = await Environment.findOneAndUpdate(
    { environmentId: param.environmentId },
    data
  );
  environment.lastUpdate = Date.now();
  await environment.save();
  return environment;
};

exports.deleteEnvironment = async param => {
  return await Environment.findOneAndDelete({ environmentId: param.environmentId });
};
