"use strict";

const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");
const Device = require("../device.model");
const uuidv4 = require('uuid/v4');
var _ = require("lodash");

exports.listDeviceById = async data =>
  await Device.findOne({ _id: data.deviceId });

exports.listDeviceByIeeeAddr = async data =>
  await Device.findOne({ ieeeAddr: data.ieeeAddr });

exports.listDeviceByNwkAddr = async data =>
  await Device.findOne({ nwkAddr: (data.nwkAddr + "")});

exports.listDevicesByEnvironment = async data =>
  await Device.find({ environment: data.environmentId });

exports.listDevices = async data => {
  let devices = await Device.find();
  return devices;
};

exports.createDevice = async data => {
  let testDevice = await Device.findOne({ ieeeAddr: data.ieeeAddr });
  if (!testDevice) {
    let device = await Device.create(data);
    await device.save();

    return device;
  } else {
    console.log("*Dispositivo já existe");
    console.log("nwkAddr(old:" + testDevice.nwkAddr + ", new:" + data.nwkAddr + ")");
    testDevice.nwkAddr = data.nwkAddr;
    let res = await Device.findOneAndUpdate ({_id: testDevice._id}, {"nwkAddr": testDevice.nwkAddr, "lastUpdate" : Date.now()});    
    return { message: "O dispositivo já existe e att o nwkAddr" };
  }
};

exports.updateDevice = async (param, data) => {
  let device = await Device.findOneAndUpdate({ _id: param.deviceId }, data);
  device.lastUpdate = Date.now();
  await device.save();
  return device;
};

exports.deleteDevice = async param => {
  return await Device.findOneAndDelete({ _id: param.deviceId });
};

exports.deleteDeviceByIeeeAddr = async data => {
  return await Device.findOneAndDelete({ ieeeAddr: data.ieeeAddr });
};

exports.deleteAllDevices = async () => {
  return await Device.deleteMany({ });
};

exports.addNewBlockedUser = async (param, data) => {
  let device = await Device.findOne({ _id: param.deviceId });
  device.blockedUsersList.push(data);
  device.lastUpdate = Date.now();
  await device.save();
  return device;
};

exports.removeBlockedUser = async (param, data) => {
  let device = await Device.findOne({ _id: param.deviceId });
  let dado = data;
  let index = _.pullAllBy(device.blockedUsersList, [data], "blockedUserID");
  device.lastUpdate = Date.now();
  await device.save();
  return device;
};