"use strict";

const Users = require("../user.model");
const encrypto = require("../../security/encrypto.service");
const authService = require("../../security/auth.services");
const Gateway = require("../gateway.model");

exports.authUser = async data => {
  if (data.password == undefined) throw new Error("Senha inválida!");

  let password = await encrypto.encryptData(data.password);
  let userFinds = await Users.findOne({
    email: data.email,
    password: password
  });

  if (userFinds) {
    verifyStatusUser(userFinds);
    let token = await authService.generateToken(userFinds);
    let gateway = await Gateway.find();
    return (data = {
      token: token,
      userID: userFinds._id,
      firstName: userFinds.firstName,
      gatewayId: gateway[0]._id
    });
  } else
    throw new Error(
      "E-mail ou senha inválidos. Insira os dados de login e tente novamente."
    );
};

exports.createAccount = async data => {
  data.password = await encrypto.encryptData(data.password);
  let user = await Users.create(data);
  await user.save();
  return user;
};

const verifyStatusUser = userStatus => {
  if (userStatus.status == "AGUARDANDO_CONFIRMACAO") {
    throw new Error("Aguardando confirmação de conta, verifique seu e-mail!");
  } else if (userStatus.status == "DESABILITADO") {
    throw new Error("Usuário desabilitado, contate o administrador do sistema");
  }
};
