"use strict";

const authServices = require("../security/auth.services");
const userDao = require("../models/DAO/user.dao");

exports.createUser = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let user = await userDao.createUser(req.body);
      res.status(200).send(user);
    } catch (err) {
      res.status(200).send({ message: err.message });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateUser = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let user = await userDao.updateUser(req.params, req.body);
      res.status(200).send(user);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteUser = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let user = await userDao.deleteUser(req.params);
      res.status(200).send(user);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.findUserById = async (req, res, next) => {
  try {
    let user = await userDao.findUserById(req.params);
    res.status(200).send(user);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.findUserByEmail = async (req, res, next) => {
  try {
    let user = await userDao.findUserByEmail(req.params);
    res.status(200).send(user);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.findUsers = async (req, res, next) => {
  try {
    let user = await userDao.findUsers(req.params);
    res.status(200).send(user);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};
