"use strict";

const authServices = require("../security/auth.services");
const scenarioDao = require("../models/DAO/scenario.dao");

exports.listScenarioById = async (req, res, next) => {
  try {
    let scenario = await scenarioDao.listScenarioById(req.params);
    res.status(200).send(scenario);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listScenarios = async (req, res, next) => {
  try {
    let scenarios = await scenarioDao.listScenarios();
    res.status(200).send(scenarios);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createScenario = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let scenario = await scenarioDao.createScenario(req.body);
      res.status(200).send(scenario);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateScenario = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let scenario = await scenarioDao.updateScenario(req.params, req.body);
      res.status(200).send(scenario);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteScenario = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let scenario = await scenarioDao.deleteScenario(req.params);
      res.status(200).send(scenario);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};
