"use strict";

const authServices = require("../security/auth.services");
const ruleDao = require("../models/DAO/rule.dao");

exports.listRuleById = async (req, res, next) => {
  try {
    let rule = await ruleDao.listRuleById(req.params);
    res.status(200).send(rule);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listRules = async (req, res, next) => {
  try {
    let rules = await ruleDao.listRules();
    res.status(200).send(rules);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createRule = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let rule = await ruleDao.createRule(req.body);
      res.status(200).send(rule);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateRule = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let rule = await ruleDao.updateRule(req.params, req.body);
      res.status(200).send(rule);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteRule = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let rule = await ruleDao.deleteRule(req.params);
      res.status(200).send(rule);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.runRules = async () => {
  let rule = await ruleDao.runRules();
};

exports.startRules = async () => {
  let rule = await ruleDao.startRules();
};

exports.stopRules = async () => {
  let rule = await ruleDao.stopRules();
};

exports.applyRulesPolitics = async () => {
  let rule = await ruleDao.applyRulesPolitics();
};
