"use strict";

const authServices = require("../security/auth.services");
const logDao = require("../models/DAO/log.dao");

exports.listLogById = async (req, res, next) => {
  try {
    let log = await logDao.listLogById(req.params);
    res.status(200).send(log);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listLogs = async (req, res, next) => {
  try {
    let logs = await logDao.listLogs();
    res.status(200).send(logs);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createLog = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let log = await logDao.createLog(req.body);
      res.status(200).send(log);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteLog = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let log = await logDao.deleteLog(req.params);
      res.status(200).send(log);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};
