"use strict";

const authServices = require("../security/auth.services");
const gatewayDao = require("../../../database/models/DAO/gateway.dao");

exports.createGateway = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let gateway = await gatewayDao.createGateway(req.body);
      res.status(200).send(gateway);
    } catch (err) {
      res.status(200).send({ message: err.message });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.listGateway = async (req, res, next) => {
  try {
    let gateway = await gatewayDao.listGateway(req.params);
    res.status(200).send(gateway);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.updateGateway = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let gateway = await gatewayDao.updateGateway(req.params, req.body);
      res.status(200).send(gateway);
    } catch (err) {
      res.status(200).send({ message: err.message });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateGatewaySerial = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let gateway = await gatewayDao.updateGatewaySerial(req.body);
      res.status(200).send(gateway);
    } catch (err) {
      res.status(200).send({ message: err.message });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteGateway = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let gateway = await gatewayDao.deleteGateway(req.params);
      res.status(200).send(gateway);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};
