"use strict";

const authServices = require("../security/auth.services");
const environmentDao = require("../models/DAO/environment.dao");

exports.listEnvironmentById = async (req, res, next) => {
  try {
    let environment = await environmentDao.listEnvironmentById(req.params);
    res.status(200).send(environment);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listEnvironments = async (req, res, next) => {
  try {
    let environments = await environmentDao.listEnvironments();
    res.status(200).send(environments);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createEnvironment = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let environment = await environmentDao.createEnvironment(req.body);
      res.status(200).send(environment);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateEnvironment = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let environment = await environmentDao.updateEnvironment(
        req.params,
        req.body
      );
      res.status(200).send(environment);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteEnvironment = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let environment = await environmentDao.deleteEnvironment(req.params);
      res.status(200).send(environment);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};
