"use strict";

const authServices = require("../security/auth.services");
const deviceDao = require("../models/DAO/device.dao");

exports.listDeviceById = async (req, res, next) => {
  try {
    let device = await deviceDao.listDeviceById(req.params);
    res.status(200).send(device);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listDeviceByIeeeAddr = async (req, res, next) => {
  try {
    let device = await deviceDao.listDeviceByIeeeAddr(req.params);
    res.status(200).send(device);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listDevicesByEnvironment = async (req, res, next) => {
  try {
    let devices = await deviceDao.listDevicesByEnvironment(req.params);
    res.status(200).send(devices);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.listDevices = async (req, res, next) => {
  try {
    let devices = await deviceDao.listDevices();
    res.status(200).send(devices);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createDevice = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.createDevice(req.body);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.updateDevice = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.updateDevice(req.params, req.body);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteDevice = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.deleteDevice(req.params);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteDeviceByIeeeAddr = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.deleteDeviceByIeeeAddr(req.params);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.deleteAllDevices = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let devices = await deviceDao.deleteAllDevices();
      res.status(200).send(devices);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.addNewBlockedUser = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.addNewBlockedUser(req.params, req.body);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};

exports.removeBlockedUser = async (req, res, next) => {
  if (req.user.data.type == "ADMIN") {
    try {
      let device = await deviceDao.removeBlockedUser(req.params, req.body);
      res.status(200).send(device);
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }
  } else {
    res.status(401).send({
      message: "Permissão negada."
    });
  }
};
