"use strict";

const account = require("../models/DAO/account.dao");
//const Account = require('../models/user');
const authService = require("../security/auth.services");

exports.authUserByEmailAndPassword = async (req, res, next) => {
  try {
    let data = await account.authUser(req.body);
    res.status(200).send(data);
  } catch (err) {
    res.status(200).send({
      message: err.message
    });
  }
};

exports.createAccount = async (req, res, next) => {
    try {
      let result = await account.createAccount(req.body);
      res.status(200).send({
        success: true,
        user: result
      });
    } catch (err) {
      res.status(200).send({
        message: err.message
      });
    }  
};

exports.verifyIfTokenIsValid = (req, res, next) =>
  res.status(200).send({
    value: true
  });
