"use strict";

// const connect = require("camo").connect;
const dbConnection = require("../../database/dbConnection");
const bodyParser = require("body-parser");
const express = require("express");
const cors = require("cors");
const app = express();
const router = express.Router();
const config = require("../config");

const index = require("./routes/index");
const accountRouter = require("./routes/account.router")();
const gatewayRouter = require("./routes/gateway.router")();
const userRouter = require("./routes/user.router")();
const deviceRouter = require("./routes/device.router")();
const environmentsRouter = require("./routes/environments.router")();
const scenarioRouter = require("./routes/scenario.router")();
const ruleRouter = require("./routes/rules.router")();
const logRouter = require("./routes/log.router")();

// var database;
// const uri = "nedb://.././database";
// connect(uri).then(function(db) {
//   database = db;
// });

app.use(bodyParser.json());
app.use(
  bodyParser.urlencoded({
    extended: true
  })
);

app.use((req, res, next) => {
  res.header("Access-Control-Allow-Origin", "*");
  next();
});

app.use(cors());

app.use(config.pathVersion, accountRouter);
app.use(config.pathVersion, index);
app.use(config.pathVersion, gatewayRouter);
app.use(config.pathVersion, userRouter);
app.use(config.pathVersion, deviceRouter);
app.use(config.pathVersion, environmentsRouter);
app.use(config.pathVersion, scenarioRouter);
app.use(config.pathVersion, ruleRouter);
app.use(config.pathVersion, logRouter);

module.exports = app;
