"use strict";

const app = require("../src/app");
const http = require("http");
const debug = require("debug")("nodestr:server");
const express = require("express");
const path = require('path');

const normalizePort = (porta = 3001) => {
  const port = parseInt(porta, 10);
  if (isNaN(porta)) return porta;

  if (port >= 0) return port;

  return false;
};

const onListening = () => {
  const addr = server.address();
  const bind = typeof addr == "string" ? `Pipe ${addr}` : `Porta ${addr.port}`;

  debug(`Evento in ${bind}`);
};
app.use(express.static(path.join(__dirname, '../../client/')));
const port = normalizePort(process.env.PORT);

app.set("port", port);

const server = http.createServer(app);

server.listen(port, err => {
  if (err) console.log(err.message);
  console.log("Running E-comfort Gateway Server at port", port);
});

server.on("error", err => {
  console.log(err);
});
server.on("listening", onListening);

app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, '../../client/'));
});

module.exports = server;
