const gatewayDAO = require("../../database/models/DAO/gateway.dao");
const chalk = require("chalk");
const pjson = require('../../package.json');

exports.create = async data => {
  var gat = {
    name: "Gateway não registrado",
    ipV4: {
      address: data.ipV4.address,
      mask: data.ipV4.mask,
      gateway: data.ipV4.gateway
    },
    timezone: {
      name: "(UTC-03:00) Brasilia",
      isdst: false,
      offset:-3
    },
    hwVersion: "0.0.1",
    fwVersion: pjson.version,
    status: "inactive",
    serialNumber: "0-0-0-0-0"
  };

  const gateway = await gatewayDAO.createGateway(gat);
  console.log(
    chalk.green("[nedb] " + gateway.name + " criado: " + gateway._id)
  );
  return gateway;
};
