const CircularJSON = require("circular-json");
const chalk = require("chalk");
const uuidv4 = require("uuid/v4");
const util = require('util');
const checkStatus = require("../services/processor.deviceStatus");
//const localClient = require("../mqtt/localClient");
const brokerClient = require("../mqtt/brokerClient");
const deviceDAO = require("../../../database/models/DAO/device.dao");
const isActive = require("../services/processor.isActive");
const ruleProcessor = require("../services/processor.rule");
const statusProcessor = require("../services/processor.status");
const smartLockProcessor = require("../services/processor.smartLock");

async function messageIncoming(msg, eventType) {
  try {
    msg.endpoints.forEach(endpoint => {
      let nwkAddr;
      let ieeeAddr;
      let cId;
      let type;
      let group;
      let value;
      if(eventType == "devChange") {
        // nwkAddr = endpoint.device.nwkAddr;
        // ieeeAddr = endpoint.device.deviceAddr;
        // cId = msg.data.cid;
        // type = (cId === "seMetering") ? Object.keys(msg.data.data)[4] : Object.keys(msg.data.data)[0];
        // group = msg.data.data;
        // value = group[type];
        return;

      } else if(eventType == "attReport") {
        nwkAddr = msg.deviceAddr;
        ieeeAddr = "";
        cId = msg.data.cid;
        type = (cId === "seMetering") ? Object.keys(msg.data.data)[4] : Object.keys(msg.data.data)[0];
        group = msg.data.data;
        value = group[type];
      }

      (async () => {
        const device = await deviceDAO.listDeviceByNwkAddr({ nwkAddr: nwkAddr });
        
        if (device != null) ieeeAddr = device.ieeeAddr;
        // else console.log(chalk.red("[message-dispatcher] [incoming] evento não encrontou dev no banco"));

        if (ieeeAddr != "") {
          setLastReport(ieeeAddr, Date.now());
          sendMessage(
            {
              ieeeAddr: ieeeAddr,
              epId: endpoint.epId,
              cId: cId,
              type: type,
              value: value
            },
            eventType
          );
        }
      })();
    })
  } catch (err) {
    console.log(chalk.red("[message-dispatcher] [incoming] " + err));
  }
}

async function sendMessage(msg, type) {
  var result = await {
    topic: "device/" + msg.ieeeAddr + "/event",
    operation: (type) ? type : "event",
    data: msg
  }
  brokerClient.publish(result);
  isActive.isActive(msg);
  ruleProcessor.testIfRuleInput(msg);
  statusProcessor.attStatus(msg);
  setIfAutolock(msg);
}

function setIfAutolock(data) {
  if (data.cId == "closuresDoorLock") {
    if (data.type == "doorState" && data.value == 1) {
      smartLockProcessor.setAutoLock(data.ieeeAddr);
    }
  }
}

async function messageLeaving(msg) {
  var result = await {
    topic: "device/" + msg.ieeeAddr + "/status",
    operation: "delete",
    data: msg
  }
  brokerClient.publish(result);
}

async function setLastReport(ieeeAddr, date) {
  await deviceDAO.updateDevice({ ieeeAddr: ieeeAddr }, { lastReport: date });
}

async function messageStatus(msg) {
  let ep = msg.endpoints[0];

  await deviceDAO.updateDevice({ ieeeAddr: ep.getIeeeAddr() }, { nwkAddr: ep.getNwkAddr(), status: msg.data });
}

module.exports.messageIncoming = messageIncoming;
module.exports.messageStatus = messageStatus;
module.exports.messageLeaving = messageLeaving;