const chalk = require("chalk");
const deviceDAO = require("../../../database/models/DAO/device.dao");
const brokerClient = require('../mqtt/brokerClient')

module.exports.attStatus = attStatus;

async function attStatus(msg) {
    const device = await deviceDAO.listDeviceByIeeeAddr({ ieeeAddr: msg.ieeeAddr });
    console.log("[status-processor] Calling")
    if (device.status == "offline"){
        console.log(chalk.blue("[status-processor] " + msg.ieeeAddr + ": " + device.status + "-> online"));
        const deviceOn = await deviceDAO.updateDevice({ ieeeAddr: msg.ieeeAddr }, { status: "online" });
        msg.data = deviceDAO.dataAdjust(deviceOn)
        msg.topic = "device/" + deviceOn.ieeeAddr + "/status"
        msg.operation = "edit"
        //console.log(msg)
        //brokerClient.publish(msg)
    }
}