const chalk = require("chalk");
const deviceDAO = require("../../../database/models/DAO/device.dao");
const shepherd = require("../shepherd/zs-shepherd");

async function setAutoLock(ieeeAddr) {
    const smartLock = await deviceDAO.listDeviceByIeeeAddr({ ieeeAddr: ieeeAddr});
    autoLockTime = smartLock.clusters[4].attributes[6].value;

    if (autoLockTime != 0 && smartLock.clusters[4].attributes[1].value == 2) {
        console.error(chalk.bgBlue("[smart lock] will check and try to autoLock in " + autoLockTime + " seconds..."));
        let start = setTimeout(async function() {
            let currentSmartLock = await deviceDAO.listDeviceByIeeeAddr({ ieeeAddr: ieeeAddr});
            if (currentSmartLock.clusters[4].attributes[1].value == 2) {
                console.error(chalk.bgBlue("[smart lock] autolock start"));
                shepherd.functional({
                    ieeeAddr: ieeeAddr,
                    epId: 8,
                    cId: "closuresDoorLock",
                    cmd: "lockDoor",
                    zclData: { pincodevalue: "00000000" }
                });
            }
        }, autoLockTime*1000);
    }
}

module.exports.setAutoLock = setAutoLock;