const chalk = require("chalk");
const ruleDAO = require("../../../database/models/DAO/rule.dao");
const gatewayDAO = require("../../../database/models/DAO/gateway.dao");
const moment = require("moment");
const scenarioService = require("../mqtt/mqtt-service/service.scenario");
const shepherd = require("../shepherd/zs-shepherd");
const _ = require("lodash");
const delay = require("delay");

module.exports.testIfRuleInput = testIfRuleInput;
module.exports.executeOutputs = executeOutputs;
module.exports.executeInverseOutputs = executeInverseOutputs;
module.exports.isTime = isTime;
module.exports.isDay = isDay;

const timeFormat = "HH:mm:ss";
const dateFormat = "YYYY-MM-DD";

async function testIfRuleInput(msg) {
  try {
    const data = ruleAdjust(msg);

    const rules = await ruleDAO.listRules();
    //console.log((new Date()).toUTCString());
    for (rule of rules) {
      if (rule.inputs) {
        // console.log(chalk.blue("[rule-processor] [test-if] " + rule.name));
        if (rule.isActive && isTime(rule.schedule)) {
          //console.log(chalk.blue("[rule-processor] isActive e ta no Schedule"));
          for (input of rule.inputs) {
            // console.log(chalk.blue("[rule-processor] " + input.cId + " = " + data.cId));
            // console.log(chalk.blue("[rule-processor] " + input.type + " = " + data.type));
            // console.log(chalk.blue("[rule-processor] " + input.ieeeAddr + " = " + data.ieeeAddr));
            if (
              input.cId == data.cId &&
              input.type == data.type &&
              input.ieeeAddr == data.ieeeAddr
            ) {
              //console.log(chalk.blue("[rule-processor] " + data.value + input.condition + input.value));
              if (input.cId == "seMetering") {
                input.value = input.value * 1000;
              } else if (input.type == "measuredValue") {
                input.value = input.value * 100;
              }
              if (
                input.condition === "=" &&
                data.value == input.value
              ) {
                //console.log(chalk.blue("[rule-processor] [test-if] value: " + JSON.stringify(msg.value) + " = " + JSON.stringify(input.value)));
                executeOutputs(rule);
              } else if (
                input.condition === ">" &&
                data.value > input.value
              ) {
                executeOutputs(rule);
              } else if (
                input.condition === "<" &&
                data.value < input.value
              ) {
                executeOutputs(rule);
              }
            }
          }
        }
      }
    }
  } catch (err) {
    console.log(chalk.red("[rule-processor] " + err));
  }
}

function ruleAdjust(msg) {
  const data = {
    ieeeAddr: msg.ieeeAddr + "",
    type: msg.type,
    value: Number(msg.value),
    cId: msg.cId,
    epId: Number(msg.epId)
  };

  return data;
}

async function executeOutputs(rule) {
  try {
    if (rule.outputs) {
      // let first,
      //   second,
      //   third = [];
      // third = _.filter(rule.outputs, function(o) {
      //   return o.cId == "genOnOff";
      // });
      // first = _.filter(rule.outputs, function(o) {
      //   return o.cmd == "moveToHueAndSaturation";
      // });
      // second = _.filter(rule.outputs, function(o) {
      //   return o.cmd == "moveToLevel";
      // });
      // console.log("THIRD>", third);
      for (command of rule.outputs) {
        const functional = await shepherd.functional(command);
        console.log(
          chalk.blue(
            "[rule-processor] [exec-outputs] functional done: " +
            JSON.stringify(functional)
          )
        );
      }

      // for (command of first) {
      //   const functional = await shepherd.functional(command);
      //   console.log(
      //     chalk.blue(
      //       "[rule-processor] [exec-outputs] functional done: " +
      //         JSON.stringify(functional)
      //     )
      //   );
      // }
      // for (command of second) {
      //   const functional = await shepherd.functional(command);
      //   console.log(
      //     chalk.blue(
      //       "[rule-processor] [exec-outputs] functional done: " +
      //         JSON.stringify(functional)
      //     )
      //   );
      // }
      // // await delay(1500);
      // for (command of third) {
      //   const functional = await shepherd.functional(command);
      //   console.log(
      //     chalk.blue(
      //       "[rule-processor] [exec-outputs] functional done: " +
      //         JSON.stringify(functional)
      //     )
      //   );
      // }
    }
    // await delay(1500);
    if (rule.sceneOutputs) {
      for (scene of rule.sceneOutputs) {
        const scenario = await scenarioService.start(scene);
        console.log(
          chalk.blue(
            "[rule-processor] [exec-outputs] scenario done: " + scene.scenarioId
          )
        );
      }
    }
  } catch (err) {
    console.log(chalk.red("[rule-processor] [exec-outputs] " + err.toString()));
  }
}

async function executeInverseOutputs(rule) {
  try {
    if (rule.outputs) {
      for (command of rule.outputs) {

        if (command.cmd == 'on')
          command.cmd = 'off'
        else if (command.cmd == 'off')
          command.cmd = 'on'

        const functional = await shepherd.functional(command);
        console.log(
          chalk.yellow(
            "[rule-processor] [exec-outputs-inverse] functional done: " +
            JSON.stringify(command)
          )
        );
      }
    }
    // await delay(1500);
  } catch (err) {
    console.log(chalk.red("[rule-processor] [exec-outputs-inverse] " + err.toString()));
  }
}

async function isTime(schedule) {
  const gateway = await gatewayDAO.listGateway();
  let startDay = schedule.interval.startDay ? schedule.interval.startDay : null;
  let today = moment().format(dateFormat)
  let startTime = schedule.interval.startHour ?
    schedule.interval.startHour
    : null;
  let endTime = schedule.interval.endHour ?
    schedule.interval.endHour : null;
  let weekdays = schedule.weekdays ? schedule.weekdays : [];

  let startDate = moment(startDay + " " + startTime).add(gateway[0].timezone.offset * 3600000)
  let endDate = moment(today + " " + endTime).add(gateway[0].timezone.offset * 3600000);
  //console.log("START::: ", startDate);
  //console.log("END::: ", endDate);

  //console.log(chalk.blue("[rule-processor] " + startDate));
  //console.log(startDate, endDate);


  if (moment().isSameOrAfter(startDate)) {
    //console.log("[rule-processor] Regra já está valendo");
    startDate = moment(today + " " + startTime);
    if (moment().isBetween(startDate, endDate) || (
      !moment().isBetween(startDate, endDate) && moment(startTime, timeFormat).isAfter(moment(endTime, timeFormat))
    )) {
      //console.log(chalk.blue("[rule-processor] PODE SER HOJE"));
      isWeekDay = weekdays.some(weekday => weekday.day === (
        moment().isSameOrAfter(startDate) ? moment().weekday() : (
          moment().isSameOrBefore(endDate) ? (moment().weekday() + 6) % 7 : null
        )
      ))
      //console.log('BOOLEANOS', moment(), startDate, endDate,  moment().isSameOrAfter(startDate), moment().isSameOrAfter(endDate), (moment().weekday() + 6) % 7)
      if (isWeekDay) {
        //console.log(chalk.blue("[rule-processor] É HOJE"));
        return true;
      }
    }
  }
  return false
}

async function isDay(schedule) {
  const gateway = await gatewayDAO.listGateway();
  let startDay = schedule.interval.startDay ? schedule.interval.startDay : null;
  let today = moment().format(dateFormat)
  let startTime = schedule.interval.startHour ?
    schedule.interval.startHour
    : null;
  let endTime = schedule.interval.endHour ?
    schedule.interval.endHour : null;
  let weekdays = schedule.weekdays ? schedule.weekdays : [];

  let startDate = moment(startDay + " " + startTime).add(gateway[0].timezone.offset * 3600000)
  let endDate = moment(today + " " + endTime).add(gateway[0].timezone.offset * 3600000);

  if (moment().isSameOrAfter(startDate)) {
    //console.log("[rule-processor] Regra já está valendo");
    startDate = moment(today + " " + startTime);
    //console.log(chalk.blue("[rule-processor] PODE SER HOJE"));
    isWeekDay = weekdays.some(weekday => weekday.day === (
      moment().isSameOrAfter(startDate) ? moment().weekday() : (
        moment().isBefore(endDate) ? (moment().weekday() + 6) % 7 : null
      )
    ))
    //console.log('BOOLEANOS', moment(), startDate, endDate,  moment().isSameOrAfter(startDate), moment().isSameOrAfter(endDate), (moment().weekday() + 6) % 7)
    if (isWeekDay) {
      //console.log(chalk.blue("[rule-processor] É HOJE"));
      return true;
    }
  }
  return false
}

