const chalk = require("chalk");
const deviceDAO = require("../../../database/models/DAO/device.dao");

module.exports.isActive = isActive;

async function isActive(msg) {
    if ((msg.cId == "genOnOff" && msg.type == "onOff") ||
        (msg.cId == "msOccupancySensing" && msg.type == "occupancy") ||
        (msg.cId == "closuresDoorLock" && msg.type == "lockState")) {
        try {
            const device = await deviceDAO.updateDevice(
                { ieeeAddr: msg.ieeeAddr }, 
                { isActive: (msg.value) ? true : false });

            console.log(chalk.green("[active-processor] " + device.ieeeAddr + ": " + device.isActive));
        }
        catch (err) {
            console.log(chalk.red("[active-processor] " + err.toString()));
        }
    } //else console.log(chalk.blue("[active-processor] " + msg.ieeeAddr + ": não alterou"));
}