const CronJob = require("node-schedule");
const ruleCronJob = require("cron").CronJob;
const ruleDAO = require("../../../database/models/DAO/rule.dao");
const ruleProcessor = require("./processor.rule")
const gatewayDAO = require("../../../database/models/DAO/gateway.dao")
const brokerClient = require("../mqtt/brokerClient");

var cron = new CronJob.scheduleJob("* * * * *", async function () {
  console.log("[periodic status] Sent every 2 minutes if gateway is active");
  let generalStatus = await gatewayDAO.getGeneralStatus()
  brokerClient.publish(generalStatus)
});

var cronRule = new ruleCronJob(
  "*/20 * * * * *",
  async function () {
    let rules = await ruleDAO.listRules();
    if (rules) {
      for (let rule of rules) {
        if (rule.isActive && !(rule.inputs && rule.inputs.length) && await ruleProcessor.isTime(rule.schedule)) {
          console.log(`[periodic rule verifier] Rule ${rule.name} is on due time period:`)
          //console.log(rule.schedule)
          ruleProcessor.executeOutputs(rule)
        }
      }
    }
  },
  null, true)

cronRule.start()
