const chalk = require("chalk");
const fs = require("fs");
var exec = require("child_process").exec;

const imageStatusFile = "/home/root/ecomfort-installer/images/imageStatus.json";

function updateFirmware() {
  console.log("UPDATING IN PROGRESS..."); 
  console.log("The gateway will restart now, this may take several minutes!");
  exec("reboot", function(err) {
    if(!err) {
      return {
        topic: "success",
        operation: "firmwareUpdate",
        data: "Firmware update started!"
      }
    } else {
      return {
        topic: "error",
        operation: "firmwareUpdate",
        data: err
      }
    }
   });
  // exec("cd /home/root/ecomfort-installer && node index.js " + data.data.fileName, function(err) {
  //   if(!err) {
  //     return {
  //       topic: "success",
  //       operation: "firmwareUpdate",
  //       data: "Updating firmware... The system will restart at the end of proccess."
  //     }
  //   } else {
  //     return {
  //       topic: "error",
  //       operation: "firmwareUpdate",
  //       data: err
  //     }
  //   }
  // });
}

async function setImageStatus(status) {
  let content = await fs.readFileSync(imageStatusFile, "utf8");
  content = JSON.parse(content);
  content.imageStatus = status;
  fs.writeFile(imageStatusFile, JSON.stringify(content), err => {
    if (err) {
        console.log(chalk.yellow("[firmware check] Cannot write file: ", err));
      return;
    }
    console.log(chalk.yellow("[firmware check] Image status OK"));
  });
}

function rebootGateway() {
  exec("reboot", function(err) {
    if (!err) {
      console.log("REBOOT started...")
    } else {
      console.log("Cannot start REBOOT")
    }
  });
}

module.exports = {
  setImageStatus,
  updateFirmware,
  rebootGateway
};