const checkJob = require("node-schedule");
var CronJob = require("cron").CronJob;
const deviceDAO = require("../../../database/models/DAO/device.dao");
const _ = require("lodash");
const moment = require("moment");
const shepherd = require("../shepherd/zs-shepherd");

var counters = [];

setInterval(async () => {
  console.log("[device status] Checking devices status every 5 minutes");
  deviceDAO.listDevices().then(devices => {
    devices.forEach(async device => {
      checkStatus(device);
    });
  })
}, 30000);

async function checkStatus(device) {
  const now = moment(new Date());
  const lastReport = moment(device.lastReport);
  const duration = moment.duration(now.diff(lastReport));

  var deviceIndex = _.findIndex(counters, function (o) {
    return o.ieeeAddr == device.ieeeAddr;
  });
  if (deviceIndex == -1)
    deviceIndex = counters.push({ ieeeAddr: device.ieeeAddr, fails: 0 }) - 1;

  switch (device.devId) {
    case "770":
      if (duration.asMinutes() > 5) {
        setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
    case "12":
      if (duration.asMinutes() > 5) {
        setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
    case "263":
      if (duration.asMinutes() > 5) {
        setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
    case "81":
      if (duration.asMinutes() > 1) {
        //setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      } 
      break;
    case "2":
      try {
        let sirenRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      break;
    case "6":
      if (duration.asDays() > 21) {
        //setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
    case "258":
      try {
        let lampRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      break;
    case "10":
      try {
        let smartLockRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      if (duration.asHours() > 0.51) {
        //setStatusOffline(device, deviceIndex);
      } else {
        if (device.status == "offline") {
          await deviceDAO.updateDevice(
            { ieeeAddr: device.ieeeAddr },
            { status: "online" }
          );
        }
      }
      break;
    case "262":
      if (duration.asMinutes() > 1) {
        //setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
    case "771":
      try {
        let spPlusRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      break;
    case "261":
      try {
        let ledRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      break;
    default:
      try {
        let defaultRead = await shepherd.shepRead({
          ieeeAddr: device.ieeeAddr,
          epId: device.epList[0],
          cId: "genBasic",
          attrId: "modelId"
        });
        setStatusOnline(device, deviceIndex);
      } catch (error) {
        //setStatusOffline(device, deviceIndex);
      }
      if (duration.asDays() > 21) {
        //setStatusOffline(device, deviceIndex);
      } else {
        setStatusOnline(device, deviceIndex);
      }
      break;
  }
}

async function setStatusOffline(device, index) {
  counters[index].fails = counters[index].fails + 1;
  if (counters[index].fails > 1) {
    if (device.status == "online") {
      await deviceDAO.updateDevice(
        { ieeeAddr: device.ieeeAddr },
        { status: "offline" }
      );
    }
  }
  console.log("[device status] ", device.name, counters[index]);
}

async function setStatusOnline(device, index) {
  counters[index].fails = 0;
  if (device.status == "offline") {
    deviceDAO.updateDevice(
      { ieeeAddr: device.ieeeAddr },
      { status: "online" }
    )
  }
  console.log("[device status] ", device.name, counters[index]);
}
