const chalk = require("chalk");
const deviceDAO = require("../../../database/models/DAO/device.dao");
const _ = require("lodash");

module.exports.updateAttributes = updateAttributes;
module.exports.adjustAttributes = adjustAttributes;

async function updateAttributes(data) {
  const device = await deviceDAO.listDeviceByNwkAddr({ nwkAddr: data.deviceAddr });
  if (device) {
    let clusters = device.clusters;
    // console.log("CLUSTERS", JSON.stringify(clusters));
    let clusterIndex = _.findIndex(device.clusters, function (o) {
      return o.cId === data.data.cid;
    });
    let attribIndex = _.findIndex(device.clusters[clusterIndex].attributes, function (o) {
      return o.name === Object.keys(data.data.data)[0];
    });
    //let clusterData = _.filter(device.clusters, function(o) { return o.cId === data.data.cid; });

    if (attribIndex != -1) {
      const devicex = await deviceDAO.listDeviceByNwkAddr({ nwkAddr: data.deviceAddr });

      let clustersx = devicex.clusters;
      clustersx[clusterIndex].attributes[attribIndex].value = data.data.data[Object.keys(data.data.data)];

      let updatedDevice = await deviceDAO.updateDevice({ ieeeAddr: device.ieeeAddr }, { clusters: clustersx });
      return updatedDevice
    }
    throw ("Device has no attribute index with name " + Object.keys(data.data.data)[0] + " - Device ieeeAddr: " + data.deviceAddr)
  }
  throw ("No device found with ieee address " + data.deviceAddr)
}

async function adjustAttributes(clusters) {
  let attributes = [];
  let aux = await Object.keys(clusters).forEach(async clusterId => {
    if (
      clusterId != "zapp" &&
      clusterId != "genBasic" &&
      clusterId != "genIdentify" &&
      clusterId != "genGroups" &&
      clusterId != "genScenes"
    ) {
      await attributes.push({
        cId: clusterId,
        attributes: await getAttributes(clusterId, clusters[clusterId])
      });
    }
  });
  return attributes;
}

async function getAttributes(cId, cData) {
  let attributes = [];

  switch (cId) {
    case "genOnOff":
      attributes.push({
        name: "onOff",
        value: cData.attrs.onOff
      });
      return attributes;

    case "genPowerCfg":
      attributes.push({
        name: "batteryPercentageRemaining",
        value: cData.attrs.batteryPercentageRemaining
      });
      return attributes;

    case "msTemperatureMeasurement":
      attributes.push({
        name: "measuredValue",
        value: cData.attrs.value
      });
      return attributes;

    case "msRelativeHumidity":
      attributes.push({
        name: "measuredValue",
        value: cData.attrs.value
      });
      return attributes;

    case "seMetering":
      attributes.push(
        {
          name: "currentSummDelivered",
          value: cData.attrs.currentSummDelivered
        },
        {
          name: "status",
          value: cData.attrs.status
        },
        {
          name: "unitOfMeasure",
          value: cData.attrs.unitOfMeasure
        },
        {
          name: "multiplier",
          value: cData.attrs.multiplier
        },
        {
          name: "divisor",
          value: cData.attrs.divisor
        },
        {
          name: "summaFormatting",
          value: cData.attrs.summaFormatting
        },
        {
          name: "meteringDeviceType",
          value: cData.attrs.meteringDeviceType
        },
        {
          name: "instantaneousDemand",
          value: cData.attrs.instantaneousDemand
        }
      );
      return attributes;

    case "genLevelCtrl":
      attributes.push({
        name: "currentLevel",
        value: cData.attrs.currentLevel
      });
      return attributes;

    case "lightingColorCtrl":
      attributes.push(
        {
          name: "currentHue",
          value: cData.attrs.currentHue
        },
        {
          name: "currentSaturation",
          value: cData.attrs.currentSaturation
        }
      );
      return attributes;

    case "msOccupancySensing":
      attributes.push({
        name: "occupancy",
        value: cData.attrs.occupancy
      });
      return attributes;

    case "closuresDoorLock":
      attributes.push(
        {
          name: "doorState",
          value: cData.attrs.doorstate
        },
        {
          name: "lockState",
          value: cData.attrs.lockState
        },
        {
          name: "actuatorEnabled",
          value: cData.attrs.actuatorEnabled
        },
        {
          name: "lockType",
          value: cData.attrs.lockType
        },
        {
          name: "ledSettings",
          value: cData.attrs.ledSettings
        },
        {
          name: "soundVolume",
          value: cData.attrs.soundVolume
        },
        {
          name: "autoLock",
          value: 0
        }
      );
      return attributes;

    case "genAlarms":
      attributes.push(
        {
          name: "alarm",
          value: cData.attrs.alarm
        }
      );
      return attributes;

    default:
      attributes.push({
        name: "unknown",
        value: "unknown"
      });
      return attributes;
  }
}
