const chalk = require("chalk");
const gtwModel = require("../../../../database/models/gateway.model");
const blackListDAO = require("../../../../database/models/DAO/user.blackList.dao");
const accessDAO = require("../../../../database/models/DAO/user.access.dao");

module.exports.exec = exec;

async function exec(operation, nJSON) {
  switch (operation) {
    case "blackList":
      console.log(chalk.green("[mqtt-service] user/blackList"));

      const data = blackListAdjust(nJSON);

      try {
        const result = await blackListDAO.updateBlackList(data);
        console.log(
          chalk.blue("[s-user-blackList] edit -> " + JSON.stringify(result))
        );

        return {
          operation: "blackList",
          data: result
        };
      } catch (err) {
        const result = await blackListDAO.createBlackList(data);
        console.log(
          chalk.blue("[s-user-blackList] add -> " + JSON.stringify(result))
        );

        return {
          operation: "blackList",
          data: result
        };
      }
      break;
    case "access":
      console.log(chalk.green("[mqtt-service] user/access"));

      const result = await updateAccess(nJSON.users);

      return {
        operation: "access",
        data: result
      };

      break;
    case "delete":
      console.log(chalk.green("[mqtt-service] user/delete"));

      const resultAccess = await accessDAO.deleteAccess({ email: nJSON.email });
      const resultBlackList = await blackListDAO.deleteBlackList({
        email: nJSON.email
      });

      return {
        operation: "delete",
        data: {
          access: resultAccess,
          blacklist: resultBlackList
        }
      };
      break;
  }
}

async function updateAccess(users) {
  for (const user of users) {
    try {
      const callback = await accessDAO.updateAccess(user);

      console.log(
        chalk.blue("[s-user-access] edit -> " + JSON.stringify(user))
      );
    } catch (err) {
      const callback = await accessDAO.createAccess(user);
      const updateGatewayStatus = await gtwModel.findOne({});
      updateGatewayStatus.status = "active";
      updateGatewayStatus.save();

      console.log(chalk.blue("[s-user-access] add -> " + JSON.stringify(user)));
    }
  }
  return await accessDAO.listAccess();
}

function blackListAdjust(data) {
  return {
    email: data.email,
    blackListDevice: data.blackListDevice,
    blackListScenario: data.blackListScenario,
    blackListEnvironment: data.blackListEnvironment
  };
}

function accessAdjust(data) {
  return {
    email: data.email,
    role: data.role,
    token: data.token
  };
}
