const chalk = require("chalk");
const shepherd = require("../../shepherd/zs-shepherd");
const delay = require('delay');
const _ = require("lodash");

const scenarioDAO = require("../../../../database/models/DAO/scenario.dao");

module.exports.exec = exec;
module.exports.start = start;

async function exec(operation, nJSON) {
    try {
        if (!operation) {
            console.log(chalk.green("[mqtt-service] scenario/config"));

            const addRes = await add(nJSON);

            return addRes;
        } else {
            switch (operation) {
                case "list":
                    console.log(chalk.green("[mqtt-service] scenario/list"));

                    const listRes = await list();

                    return listRes;
                    break;
                case "edit":
                    console.log(chalk.green("[mqtt-service] scenario/+/edit"));

                    const editRes = await edit(nJSON);

                    return editRes;
                    break;
                case "delete":
                    console.log(chalk.green("[mqtt-service] scenario/+/delete"));

                    const deleteRes = await remove(nJSON);

                    return deleteRes;
                    break;
                case "start":
                    console.log(chalk.green("[mqtt-service] scenario/+/start"));

                    const startRes = await start(nJSON);

                    return startRes;
                    break;
            }
        }
    } catch (err) {
        console.error(chalk.red("[s-scenario] " + err));
        return ({
            topic: "error",
            data: err.toString()
        })
    }
}

function scenarioAdjust(nJSON) {
    const data = {
        scenarioId: nJSON.scenarioId,
        name: nJSON.name,
        actions: nJSON.actions
    }

    return data;
}

async function add(nJSON) {
    const data = await scenarioAdjust(nJSON);

    const scenario = await scenarioDAO.createScenario(data);

    return ({
        topic: "scenario/" + scenario.scenarioId + "/status",
        operation: "add",
        data: scenario
    })
}

async function list() {
    const scenarios = await scenarioDAO.listScenarios();

    return ({
        topic: "scenario/status",
        operation: "list",
        data: scenarios
    })
}

async function edit(nJSON) {
    const data = await scenarioAdjust(nJSON);

    const scenarioEdited = await scenarioDAO.updateScenario({ scenarioId: data.scenarioId }, data);

    return ({
        topic: "scenario/" + scenarioEdited.scenarioId + "/status",
        operation: "edit",
        data: scenarioEdited
    })
}

async function remove(nJSON) {
    await shepherd.updateRules(null, nJSON.scenarioId);
    await scenarioDAO.deleteScenario(nJSON.scenarioId);

    return ({
        topic: "scenario/" + nJSON.scenarioId + "/status",
        operation: "delete",
        data: { scenarioId: nJSON.scenarioId }
    })
}

async function start(nJSON) {
    const scenarioStart = await scenarioDAO.listScenarioById(nJSON.scenarioId);

    if (scenarioStart) {
        
        let first, second, third = [];
        third = _.filter(scenarioStart.actions, function(o) { return (o.cId == 'genOnOff'); });
        first = _.filter(scenarioStart.actions, function(o) { return (o.cmd == 'moveToHueAndSaturation'); });
        second = _.filter(scenarioStart.actions, function(o) { return (o.cmd == 'moveToLevel'); });

        for (command of first) {
            const functional = await shepherd.functional(command);
            console.log(chalk.yellow("[s-scenario-start]  " + command.cmd + " " + JSON.stringify(command.zclData)));
        }
        for (command of second) {
            const functional = await shepherd.functional(command);
            console.log(chalk.yellow("[s-scenario-start]  " + command.cmd + " " + JSON.stringify(command.zclData)));
        }
        // await delay(1500);
        for (command of third) {
            const functional = await shepherd.functional(command);
            console.log(chalk.yellow("[s-scenario-start]  " + command.cmd + " " + JSON.stringify(command.zclData)));
        }
        // for (const functional of scenarioStart.actions) {
        //     console.log(chalk.yellow("[s-scenario-start]  " + functional.cmd + " " + JSON.stringify(functional.zclData)));
        //     shepherd.functional(functional);
        //     await delay(300);
        // }
    }

    return ({
        topic: "scenario/" + scenarioStart.scenarioId + "/status",
        operation: "start",
        data: scenarioStart
    })
}