const chalk = require("chalk");
const shepherd = require("../../shepherd/zs-shepherd");
const delay = require("delay");
const cron = require("../../cronJobs/rulesCron.services");

const ruleDAO = require("../../../../database/models/DAO/rule.dao");

module.exports.exec = exec;

async function exec(operation, nJSON) {
  try {
    if (!operation) {
      console.log(chalk.green("[mqtt-service] rule/config"));

      const addRes = await add(nJSON);

      return addRes;
    } else {
      switch (operation) {
        case "edit":
          console.log(chalk.green("[mqtt-service] rule/+/edit"));

          const editRes = await edit(nJSON);

          return editRes;
          break;
        case "delete":
          console.log(chalk.green("[mqtt-service] rule/+/delete"));

          const deleteRes = await remove(nJSON);

          return deleteRes;
          break;
      }
    }
  } catch (err) {
    console.error(chalk.red("[s-rule] " + err));
    return {
      topic: "error",
      data: err.toString()
    };
  }
}

function ruleAdjust(nJSON) {
  const data = {
    ruleId: nJSON.ruleId,
    name: nJSON.name,
    inputs: nJSON.inputs,
    outputs: nJSON.outputs ? nJSON.outputs : null,
    sceneOutputs: nJSON.sceneOutputs ? nJSON.sceneOutputs : null,
    schedule: nJSON.schedule,
    isActive: nJSON.isActive
  };

  return data;
}

async function add(nJSON) {
  const data = await ruleAdjust(nJSON);

  const rule = await ruleDAO.createRule(data);
  if (!rule.inputs || rule.inputs.length == 0) {
    await cron.createJob(rule);
  }

  return {
    topic: "rule/" + rule.ruleId + "/status",
    operation: "add",
    data: rule
  };
}

async function edit(nJSON) {
  const data = await ruleAdjust(nJSON);

  const ruleEdited = await ruleDAO.updateRule(data.ruleId, data);
  await cron.resetJobs();

  return {
    topic: "rule/" + ruleEdited.ruleId + "/status",
    operation: "edit",
    data: ruleEdited
  };
}

async function remove(nJSON) {
  const data = await ruleAdjust(nJSON);

  const ruleDeleted = await ruleDAO.deleteRule(data.ruleId);
  await cron.resetJobs();

  return {
    topic: "rule/" + data.ruleId + "/status",
    operation: "delete",
    data: ruleDeleted
  };
}
