const chalk = require("chalk");
const userService = require('./service.user');
const gtwService = require('./service.gateway');
const deviceService = require('./service.device');
const scenarioService = require('./service.scenario');
const ruleService = require('./service.rule');
const environmentService = require('./service.environment');

// Export it to make it available outside
module.exports.exec = exec;

async function exec(topic, message) {
    try {
        var nJSON = (message == "") ? JSON.parse({}) : JSON.parse(message);
        var splitedTopic = topic.split("/");
        var response = {
            data: null,
            operation: null,
            topic: null
        }

        switch (splitedTopic[6]) {
            case "refresh":
                return ({
                    data: await gtwService.execRefresh(),
                    operation: "refresh",
                    topic: "success"
                })
                break;
            case "config":
                return ({
                    data: await gtwService.execConfig(nJSON),
                    operation: "config",
                    topic: "status"
                })
                break;
            case "update":
                const opResp = await gtwService.execUpdate(nJSON)
                return ({
                    data: opResp.data,
                    operation: opResp.operation,
                    topic: opResp.topic
                })
                break;
            case "reset":
                return ({
                    data: await gtwService.execReset(nJSON),
                    operation: "reset",
                    topic: "success"
                })
                break;
            case "addDevice":
                return ({
                    data: await gtwService.execJoin(nJSON),
                    operation: "join",
                    topic: "success"
                })
                break;
            case "device":
                nJSON.ieeeAddr = splitedTopic[7];
                const deviceResp = await deviceService.exec(splitedTopic[8], nJSON);
                response = {
                    topic: await deviceResp.topic,
                    operation: await deviceResp.operation,
                    data: await deviceResp.data
                };
                if(response.operation == "functional") {
                    response.command = {
                        user: nJSON.user ? nJSON.user : null,
                        ieeeAddr: nJSON.ieeeAddr ? nJSON.ieeeAddr : null,
                        cId: nJSON.cId ? nJSON.cId : null,
                        cmd: nJSON.cmd ? nJSON.cmd : null,
                        zclData: nJSON.zclData ? nJSON.zclData : null
                    };
                }
                return response;
                
                break;
            case "environment":
                nJSON.environmentId = (splitedTopic[8]) ? splitedTopic[7] : nJSON.environmentId;
                const environmentResp = await environmentService.exec(splitedTopic[8], nJSON);
                return ({
                    topic: environmentResp.topic,
                    operation: environmentResp.operation,
                    data: environmentResp.data
                });
                break;
            case "scenario":
                nJSON.scenarioId = (splitedTopic[8]) ? splitedTopic[7] : nJSON.scenarioId;
                const scenarioResp = await scenarioService.exec(splitedTopic[8], nJSON);
                return ({
                    topic: scenarioResp.topic,
                    operation: scenarioResp.operation,
                    data: scenarioResp.data
                });
                break;
            case "rule":
                nJSON.ruleId = (splitedTopic[8]) ? splitedTopic[7] : nJSON.ruleId;
                const ruleResp = await ruleService.exec(splitedTopic[8], nJSON);
                return ({
                    topic: ruleResp.topic,
                    operation: ruleResp.operation,
                    data: ruleResp.data
                });
                break;
            case "list":
                return ({
                    data: await gtwService.execSync(),
                    operation: "list",
                    topic: "device/status"
                })
                break;
            case "user":
                const userRes = await userService.exec(splitedTopic[7], nJSON);
                userRes.topic = "user/status";
                return (userRes);
                break;
            default:
        }
    } catch (err) {
        console.error(chalk.red("[mqtt-service] " + err));
        return ({
            topic: "error",
            data: err.toString()
        })
    }


}
