const chalk = require("chalk");

const deviceDAO = require("../../../../database/models/DAO/device.dao");
const environmentDAO = require("../../../../database/models/DAO/environment.dao");

module.exports.exec = exec;

async function exec(operation, nJSON) {
    try {
        if (!operation) {
            console.log(chalk.green("[mqtt-service] environment/config"));

            const addRes = await add(nJSON);

            return addRes;
        } else {
            switch (operation) {
                case "edit":
                    console.log(chalk.green("[mqtt-service] environment/+/edit"));

                    const editRes = await edit(nJSON);

                    return editRes;
                    break;
                case "delete":
                    console.log(chalk.green("[mqtt-service] environment/+/delete"));

                    const removeRes = await remove(nJSON);

                    return removeRes;
                    break;
            }
        }
    } catch (err) {
        console.error(chalk.red("[s-environment] " + err));
        return ({
            topic: "error",
            data: err.toString()
        })
    }
}

async function add(nJSON) {
    const data = await envAdjust(nJSON);

    const environment = await environmentDAO.createEnvironment(data);

    for (device of data.devices) await deviceDAO.updateDevice(device, { environment: { name: data.name, environmentId: environment.environmentId } });

    return ({
        topic: "environment/" + data.environmentId + "/status",
        operation: "add",
        data: environment
    })
}

async function edit(nJSON) {
    const data = await envAdjust(nJSON);

    const environment = await environmentDAO.listEnvironmentById({ environmentId: data.environmentId });

    if (environment.devices)
        for (device of environment.devices) await deviceDAO.updateDevice(device, { environment: {} });

    if (data.devices)
        for (device of data.devices) {
            let edited = await deviceDAO.updateDevice(device, { environment: { name: data.name, environmentId: environment.environmentId } });
        }

    const newEnvironment = await environmentDAO.updateEnvironment({ environmentId: data.environmentId }, data);


    return ({
        topic: "environment/" + data.environmentId + "/status",
        operation: "edit",
        data: newEnvironment
    })
}

async function remove(nJSON) {

    const environment = await environmentDAO.listEnvironmentById({ environmentId: nJSON.environmentId });

    if (environment.devices)
        for (device of environment.devices) await deviceDAO.updateDevice(device, { environment: {} });

    const callback = await environmentDAO.deleteEnvironmentById({ environmentId: nJSON.environmentId });

    return ({
        topic: "environment/" + nJSON.environmentId + "/status",
        operation: "delete",
        data: callback
    })
}

function envAdjust(nJSON) {
    const data = {
        environmentId: nJSON.environmentId,
        name: nJSON.name,
        devices: nJSON.devices
    }

    return data;
}