const chalk = require("chalk");
const shepherd = require("../../shepherd/zs-shepherd");
const delay = require("delay");
const deviceDAO = require("../../../../database/models/DAO/device.dao");
const environmentDAO = require("../../../../database/models/DAO/environment.dao");

module.exports.exec = exec;
module.exports.updateEnvs = updateEnvs;

async function exec(operation, nJSON) {
  try {
    switch (operation) {
      case "command":
        console.log(chalk.green("[mqtt-service] device/+/command"));

        const commandRes = await command(nJSON);

        return commandRes;
        break;
      case "edit":
        console.log(chalk.green("[mqtt-service] device/+/edit"));

        const data = await editAdjust(nJSON);

        const editedDevice = await updateDev(data);

        return {
          topic: "device/" + editedDevice.ieeeAddr + "/status",
          operation: "edit",
          data: editedDevice
        };
        break;
      case "delete":
        console.log(chalk.green("[mqtt-service] device/+/delete"));

        const deleteRes = await deleteDevice({ ieeeAddr: nJSON.ieeeAddr });

        return deleteRes;

        break;
      case "bind":
        console.log(chalk.green("[mqtt-service] device/+/bind"));

        const bindRes = await bind(nJSON);

        return bindRes;
        break;
      case "unbind":
        console.log(chalk.green("[mqtt-service] device/+/unbind"));

        const unbindRes = await unbind(nJSON);

        return unbindRes;
        break;
      case "read":
        console.log(chalk.green("[mqtt-service] device/+/read"));

        const readRes = await read(nJSON);
        return readRes;
        break;
      case "write":
        console.log(chalk.green("[mqtt-service] device/+/write"));

        const writeRes = await write(nJSON);
        return writeRes;
        break;
      case "smartlock":
        console.log(chalk.green("[mqtt-service] device/+/smartlock"));

        const smartLockRes = await smartlock();

        //return commandRes;
        break;
    }
  } catch (err) {
    console.error(chalk.red("[s-device] " + err));
    return {
      topic: "error",
      operation: operation,
      data: err.toString()
    };
  }
}

function editAdjust(nJSON) {
  const data = {};
  data.ieeeAddr = nJSON.ieeeAddr;
  nJSON.name ? (data.name = nJSON.name) : "";
  nJSON.environment ? (data.environment = nJSON.environment) : {};
  nJSON.devId ? (data.devId = nJSON.devId) : "";
  return data;
}

function writeAdjust(nJSON) {
  const data = {};
  data.ieeeAddr = nJSON.ieeeAddr;
  data.led = ((nJSON.led == "2")||(nJSON.led == true)) ? 2 : 0;
  data.buzzer = ((nJSON.buzzer == "2")||(nJSON.buzzer == true)) ? 2 : 0;
  data.autolock = nJSON.autolock ? Number(nJSON.autolock) : 0;

  return data;
}

function bindAdjust(nJSON) {
  var data = {
    input: {
      ieeeAddr: nJSON.input.ieeeAddr,
      epId: Number(nJSON.input.epId)
    },
    outputs: nJSON.outputs
  };

  return data;
}

async function command(data) {
  if (deviceDAO.listDeviceByIeeeAddr(data)) {
    return {
      topic: "success",
      operation: "functional",
      data: await shepherd.functional(data)
    };
  } else {
    console.log(
      chalk.red("[s-device] [command] device no shep, mas não esta no banco")
    );
    return {
      topic: "error",
      operation: "functional",
      data: "Device não encontrado no banco de dados"
    };
  }
}

async function smartlock() {
  console.log(">>>>>>>>>>>>>>> TESTANDO FECHADURA >>>>>>>>>>>>>>>>>>");
  let count = 0;
  let isLocked = false;
  while (count >= 0) {
    delay(7000);
    if (isLocked) {
      try {
        const fun1 = await shepherd.functional({
          ieeeAddr: "0x00124b0008023185",
          epId: 8,
          cId: "closuresDoorLock",
          cmd: "unlockDoor",
          zclData: { pincodevalue: "00000000" }
        });
        isLocked = false;
        count++;
        console.log("");
        console.log("TESTE FECHADURA >>>>>>>>>>>   ", count);
        console.log("");
      } catch (error) {
        console.log("");
        console.log("TESTE FECHADURA CONCLUÍDO >>>>>>>>>>>   ", count);
        console.log("");
        count = -1;
      }
    } else if (!isLocked) {
      try {
        const fun1 = await shepherd.functional({
          ieeeAddr: "0x00124b0008023185",
          epId: 8,
          cId: "closuresDoorLock",
          cmd: "lockDoor",
          zclData: { pincodevalue: "00000000" }
        });
        isLocked = true;
        count++;
        console.log("");
        console.log("TESTE FECHADURA >>>>>>>>>>>   ", count);
        console.log("");
      } catch (error) {
        console.log("");
        console.log("TESTE FECHADURA CONCLUÍDO >>>>>>>>>>>   ", count);
        console.log("");
        count = -1;
      }
    }
  }
}

async function bind(nJSON) {
  const bind = await bindAdjust(nJSON);

  for (output of bind.outputs) {
    bind.input.cId = "genOnOff";
    const bind1 = await shepherd.bind(bind.input, output);
    console.log(
      chalk.blue(
        "[s-device] [bind] " +
          bind.input.cId +
          ": " +
          bind.input.ieeeAddr +
          "->" +
          output.ieeeAddr
      )
    );

    bind.input.cId = "genLevelCtrl";
    const bind2 = await shepherd.bind(bind.input, output);
    console.log(
      chalk.blue(
        "[s-device] [bind] " +
          bind.input.cId +
          ": " +
          bind.input.ieeeAddr +
          "->" +
          output.ieeeAddr
      )
    );
  }

  return {
    topic: "device/" + bind.input.ieeeAddr + "/status",
    operation: "bind",
    data: bind
  };
}

async function unbind(nJSON) {
  const unbind = await bindAdjust(nJSON);

  for (output of unbind.outputs) {
    unbind.input.cId = "genOnOff";
    const unbind1 = await shepherd.unbind(unbind.input, output);
    console.log(chalk.blue("[s-device] [unbind] " + unbind1));

    unbind.input.cId = "genLevelCtrl";
    const unbind2 = await shepherd.unbind(unbind.input, output);
    console.log(chalk.blue("[s-device] [unbind] " + unbind2));
  }

  return {
    topic: "device/" + unbind.input.ieeeAddr + "/status",
    operation: "unbind",
    data: unbind
  };
}

async function write(nJSON) {
  const data = await writeAdjust(nJSON);
  const device = await deviceDAO.listDeviceByIeeeAddr({ ieeeAddr: data.ieeeAddr });

  console.log(device.clusters[4].attributes);

  const ledWrite = await shepherd.write({
    ieeeAddr: data.ieeeAddr,
    attrId: "ledSettings",
    value: data.led
  });
  device.clusters[4].attributes[4] = { name: "ledSettings", value: data.led.toString() };
  console.log(chalk.blue("[s-device] [write] ledSettings " + ledWrite));
  console.log(device.clusters[4].attributes[4]);

  const buzzerWrite = await shepherd.write({
    ieeeAddr: data.ieeeAddr,
    attrId: "soundVolume",
    value: data.buzzer
  });
  device.clusters[4].attributes[5] = { name: "soundVolume", value: data.buzzer.toString() };
  console.log(device.clusters[4].attributes[5]);
  console.log(chalk.blue("[s-device] [write] buzzer " + buzzerWrite));

  const autoLockWrite = data.autolock.toString();
  device.clusters[4].attributes[6] = { name: "autolock", value: autoLockWrite };
  await deviceDAO.updateDevice({ ieeeAddr: data.ieeeAddr }, { clusters: device.clusters });
  console.log(chalk.blue("[s-device] [write] autolock " + autoLockWrite));

  return {
    topic: "device/" + data.ieeeAddr + "/status",
    operation: "write",
    data: {
      led: ledWrite,
      buzzer: buzzerWrite,
      autolock: autoLockWrite
    }
  };
}

async function read(nJSON) {
  const data = await writeAdjust(nJSON);
  const device = await deviceDAO.listDeviceByIeeeAddr({ ieeeAddr: data.ieeeAddr });

  const ledRead = await shepherd.read({
    ieeeAddr: data.ieeeAddr,
    attrId: "ledSettings"
  });
  console.log(chalk.blue("[s-device] [read] ledSettings " + ledWrite));

  const buzzerRead = await shepherd.read({
    ieeeAddr: data.ieeeAddr,
    attrId: "soundVolume"
  });
  console.log(chalk.blue("[s-device] [read] buzzer " + buzzerWrite));

  const autoLockRead = await device.clusters[4].attributes[6].value;
  console.log(chalk.blue("[s-device] [read] autolock " + autoLockWrite));

  return {
    topic: "device/" + data.ieeeAddr + "/status",
    operation: "read",
    data: {
      led: ledRead,
      buzzer: buzzerRead,
      autolock: autoLockRead
    }
  };
}

async function deleteDevice(dev) {
  try {
    const shepDevice = await shepherd.remove(dev);
    console.log(
      chalk.blue(
        "[s-device] [delete-shep] " +
          dev.ieeeAddr +
          ": " +
          JSON.stringify(shepDevice)
      )
    );
  } catch (err) {
    console.log(
      chalk.red("[s-device] [delete-shep] shepherd device não respondeu.")
    );
    await shepherd.removeFromShep(dev);
    await shepherd.updateEnvironments(dev);
    await shepherd.updateRules(dev, null);
    await shepherd.updateScenarios(dev);
  }

  //const nedbDevice = await deviceDAO.deleteDeviceByIeeeAddr(dev);

  return {
    topic: "success",
    operation: "delete",
    data: dev.ieeeAddr
  };
}

async function updateDev(data) {
  const device = await deviceDAO.listDeviceByIeeeAddr({
    ieeeAddr: data.ieeeAddr
  });

  console.log("[s-device] [updev-data] " + JSON.stringify(data));
  console.log(
    "[s-device] [updev-device] " +
      device.ieeeAddr +
      ": " +
      JSON.stringify(device.environment)
  );

  if (data.environment) {
    if (data.environment.id != device.environment.id) {
      const envs = await updateEnvs(data, device);
    }
  }

  const editedDev = await deviceDAO.updateDevice(
    { ieeeAddr: data.ieeeAddr },
    data
  );

  return editedDev;
}

async function updateEnvs(data, device) {
  const environmentA = await environmentDAO.listEnvironmentById({
    environmentId: device.environment.id
  });
  const environmentB = await environmentDAO.listEnvironmentById({
    environmentId: data.environment.id
  });

  if (environmentA) {
    const devsA = [];
    for (devA of environmentA.devices) {
      if (devA.ieeeAddr != device.ieeeAddr) devsA.push(devA);
    }
    console.log(
      chalk.blue(
        "[s-device] [update-device-env] A " +
          environmentA.name +
          ": " +
          JSON.stringify(devsA)
      )
    );
    const envAafter = await environmentDAO.updateEnvironment(
      { environmentId: environmentA.environmentId },
      { devices: devsA }
    );
  }

  if (environmentB) {
    const devsB = environmentB.devices;
    devsB.push({
      ieeeAddr: device.ieeeAddr,
      devId: device.devId,
      name: data.name ? data.name : device.name
    });
    console.log(
      chalk.blue(
        "[s-device] [update-device-env] B " +
          environmentB.name +
          JSON.stringify(devsB)
      )
    );
    const envBafter = await environmentDAO.updateEnvironment(
      { environmentId: environmentB.environmentId },
      { devices: devsB }
    );
  }
}

/*   DELETE
try {
    console.log(chalk.blue("[s-device] [delete-shep] " + dev.ieeeAddr));
    const shepDevice = await shepherd.remove(dev);

    const nedbDevice = await deviceDAO.deleteDeviceByIeeeAddr(dev);
    console.log(chalk.blue("[s-device] [delete-nedb] " + nedbDevice));



    return ({
        topic: "success",
        operation: "delete",
        data: dev.ieeeAddr
    });
} catch (err) {
    console.log(chalk.red("[s-device] [delete-shep] shepherd device não respondeu."));

    const nedbDevice = await deviceDAO.deleteDeviceByIeeeAddr(dev);
    console.log(chalk.blue("[s-device] [delete-nedb] " + nedbDevice));

    return ({
        topic: "success",
        operation: "delete",
        data: dev.ieeeAddr
    });
}*/
