const chalk = require("chalk");
const uuidv4 = require("uuid/v4");
const mqtt = require("mqtt");
const util = require("util");
const moment = require("moment");
const delay = require("delay");
const crypto = require("crypto-js");
const service = require("./mqtt-service/service");
const Gateway = require("../../../database/models/gateway.model");
const gatewayDAO = require("../../../database/models/DAO/gateway.dao")

const topics = [
  "/refresh",
  "/addDevice",
  "/config",
  "/list",
  "/update",
  "/reset",
  "/user/access",
  "/user/blackList",
  "/user/delete",
  "/device/+/smartlock",
  "/device/+/command",
  "/device/+/edit",
  "/device/+/bind",
  "/device/+/unbind",
  "/device/+/write",
  "/device/+/read",
  "/device/+/delete",
  "/scenario/list",
  "/scenario/config",
  "/scenario/+/edit",
  "/scenario/+/delete",
  "/scenario/+/start",
  "/rule/config",
  "/rule/+/edit",
  "/rule/+/delete",
  "/environment/config",
  "/environment/+/edit",
  "/environment/+/delete"
]

localClient = mqtt.connect("mqtt://127.0.0.1:1883");
cloudClient = mqtt.connect("mqtt://mqtt.ecomfort.com.br:1883", {
  keepalive: 3, //set it to periodic status interval,
  clean: true,
  username: "ecomfort-gateway",
  password: "ecomfort*2018"
})

var cryptoKey = ''
var preTopic = "";

cloudClient.on("connect", async connack => initialize("local", cloudClient));
localClient.on("connect", async connack => initialize("cloud", localClient));
localClient.on("message", (topic, encryptedMessage) => onMessage("local", topic, encryptedMessage));
cloudClient.on("message", (topic, encryptedMessage) => onMessage("cloud", topic, encryptedMessage));
//cloudClient.on("close", () => console.log("CONNECTION CLOSED"))

async function initialize(clientLabel, client) {
  console.log(chalk.magenta(`[${clientLabel}] Connection (re)stablished`))
  await delay(3000);
  Gateway.findOne({}).then(function (gateway) {
    preTopic = "ecomfort/iot/v1/s2g/gateway/" + gateway.serialNumber;
    cryptoKey = crypto.SHA256('pixel' + gateway.serialNumber).toString()
    //console.log(chalk.magenta("[cloud-mqtt] topic: ", topic, cryptoKey));
    gatewayDAO.getGeneralStatus().then((res) => publish(res))

    client.subscribe(
      topics.map(topic => preTopic + topic ),
      { qos: 0 }
    );
  });
}

async function onMessage(client, topic, encryptedMessage) {
  try {
    var message = crypto.AES.decrypt(encryptedMessage.toString(), cryptoKey).toString(crypto.enc.Utf8)
  } catch (err) {
    console.log(chalk.red("[crypto] " + err));
    data = {
      data: err.toString(),
      topic: "error"
    };
    publish(data, correlId);
    return
  }

  console.log(
    chalk.hex("#fc7e81")(
      `---------------[${client}]--------SUBSCRIBE-------[${client}]---------------`
    )
  );
  console.log(chalk.hex("#fc7e81")("---Topico: ", topic));
  console.log(chalk.hex("#fc7e81")("---Payload: "));
  console.log(chalk.hex("#fc7e81")(message.toString()));
  console.log(
    chalk.hex("#fc7e81")(
      `--------------------------------------------------------------------`
    )
  );

  try {
    var correlId = JSON.parse(message).messageId;

    service
      .exec(topic, message)
      .then(result => {
        console.log(chalk.green("[cloudClient] " + JSON.stringify(result)));
        if (result.topic == "error" ) result.command = { topic, message: JSON.parse(message) }
        publish(result, correlId);
      })
      .catch(err => {
        console.log(chalk.red("[cloudClient] " + err.toString()));
        data = {
          data: err,
          topic: "error"
        };
        publish(data, correlId);
      });
  } catch (err) {
    console.log(chalk.red("[cloudClient] " + err));
    data = {
      data: err.toString(),
      topic: "error"
    };
    publish(data, correlId);
  }
}

function publish(result, correlId) {
  if (!result) return
  payload = {
    messageId: uuidv4(),
    correlId: correlId ? correlId : null,
    timestamp: moment(Date.now()).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),
    operation: result.operation ? result.operation : null,
    data: result.data
  };
  if ((result.operation == "functional") || (result.data.topic == "error") || (result.topic == "error")) {
    payload.command = result.command;
  }

  console.log(
    chalk.magenta(
      "-------------------------------PUBLISH------------------------------"
    )
  );
  console.log(chalk.magenta("---Topico: " + getPreTopic() + result.topic));
  console.log(chalk.magenta("---Payload: "));
  console.log(chalk.magenta(util.inspect(payload)));
  console.log(
    chalk.magenta(
      "--------------------------------------------------------------------"
    )
  );

  let encryptedPayload = crypto.AES.encrypt(JSON.stringify(payload), cryptoKey).toString()
  
  localClient.publish(
    getPreTopic() + result.topic,
    encryptedPayload,
    { qos: 0 }, /*, { retain: true }*/
  );

  cloudClient.publish(
    getPreTopic() + result.topic,
    encryptedPayload,
    { qos: 0 }, /*, { retain: true }*/
  );
}

function getPreTopic() {
  return preTopic + "/";
}

module.exports.publish = publish;