var CronJob = require("cron").CronJob;
const chalk = require("chalk");
const ruleDAO = require("../../../database/models/DAO/rule.dao");
const gatewayDAO = require("../../../database/models/DAO/gateway.dao");
const ruleProcessor = require("../services/processor.rule");
const moment = require("moment");

var jobs = [];

async function createJob(rule) {
  console.log(chalk.blue("[rule-scheduler] [new job] " + rule.ruleId));

  const gateway = await gatewayDAO.listGateway();
  //let startMoment = moment(rule.schedule.interval.startDay + " " + rule.schedule.interval.startHour).add((gateway[0].timezone.offset) * 3600000).format('YYYY-MM-DD HH:mm');
  //let endMoment = moment("2420-12-12" + " " + rule.schedule.interval.endHour).add((gateway[0].timezone.offset) * 3600000).format('YYYY-MM-DD HH:mm');

  let startDate = new Date(
    Date.parse(`${rule.schedule.interval.startDay}T${rule.schedule.interval.startHour}`)
    + gateway[0].timezone.offset * 3600000
  )

  let endDateValue = Date.parse(`${rule.schedule.interval.startDay}T${rule.schedule.interval.endHour}`)
    + gateway[0].timezone.offset * 3600000;
  let endDate = new Date(endDateValue)

  let startWeekdays = rule.schedule.weekdays.map(weekday => weekday.day);
  let endWeekdays = startWeekdays;

  if (startDate.valueOf() > endDateValue) {
    endDate = new Date(endDateValue + 24 * 3600000)
    endWeekdays = endWeekdays.map(weekday => (weekday + 1) % 7)
  }

  let startTime = startDate.getUTCSeconds() + ' ' +
    startDate.getUTCMinutes() + ' ' +
    startDate.getUTCHours() + ' ' +
    '* ' +
    '* ' +
    startWeekdays;

  let endTime = endDate.getUTCSeconds() + ' ' +
    endDate.getUTCMinutes() + ' ' +
    endDate.getUTCHours() + ' ' +
    '* ' +
    '* ' +
    endWeekdays;

  scheduleRule(startTime, rule)
  scheduleInverseRule(endTime, rule)
}

async function scheduleRule(time, rule) {
  console.log(chalk.blue("[job schedule] Start", time));
  let ruleStart = await new CronJob(
    time,
    async function () {
      //console.log('THIS A STORED CRON')
      let outputs = await ruleDAO.listRuleById({ ruleId: rule.ruleId });
      if (outputs && outputs.isActive && await ruleProcessor.isTime(outputs.schedule)) {
        //console.log('EXECUTING RULE ON SCHEDULE')
        let execute = ruleProcessor.executeOutputs(outputs);
      }
    },
    null,
    true
  );
  ruleStart.start()
  jobs.push(ruleStart)
}

async function scheduleInverseRule(time, rule) {
  console.log(chalk.blue('[job schedule] End', time))
  var ruleEnd = await new CronJob(
    time,
    async function () {
      let outputs = await ruleDAO.listRuleById({ ruleId: rule.ruleId });
      //console.log('DISABLING SCHEDULED RULE')
      if (outputs && outputs.isActive && await ruleProcessor.isDay(outputs.schedule)) {
        let execute = ruleProcessor.executeInverseOutputs(outputs);
      }
    },
    null,
    true
  );
  ruleEnd.start()
  jobs.push(ruleEnd)
}

async function clearJobs() {
  await stopAllJobs()
  jobs = [];
}

async function resetJobs() {
  await clearJobs()
  console.log("JOBS: ", jobs)
  const rules = await ruleDAO.listRules();
  for (let i = 0; i < rules.length; i++) {
    const rule = rules[i];
    if ((!rule.inputs || rule.inputs.length == 0) && (rule.isActive)) {
      await createJob(rule);
    }
  }
  startAllJobs()
}

async function stopAllJobs() {
  await jobs.forEach(rule => {
    rule.stop();
  });
}

function startAllJobs() {
  jobs.forEach(rule => {
    //console.log('ENABLING CRON RULES ENTRIES')
    rule.start();
  });
}

//Used on node upstart, it reschedule also the inverse rule
async function reScheduleJobs() {
  //console.log("JOBS: ", jobs)
  const rules = await ruleDAO.listRules();
  for (let i = 0; i < rules.length; i++) {
    const rule = rules[i];
    if ((!rule.inputs || rule.inputs.length == 0) && (rule.isActive)) {
      await createJob(rule);
    }
  }
  startAllJobs()
}

module.exports = {
  jobs,
  createJob,
  clearJobs,
  resetJobs,
  startAllJobs,
  stopAllJobs,
}
