const job = require("node-schedule");
const chalk = require("chalk");
const ruleDAO = require("../../../database/models/DAO/rule.dao");
const ruleProcessor = require("../services/processor.rule");

const schedules = [];

module.exports = {
  schedules,
  createSchedule
};

async function createSchedule(rule) {
  console.log(chalk.blue("[rule-scheduler] [new job] " + rule.ruleId + ": " + JSON.stringify(rule)));
  // console.log("*********NOVA REGRA********", rule);

  let start = rule.schedule.interval.startHour.split(":");
  let end = rule.schedule.interval.endHour.split(":");
  let weekdays = [];
  await rule.schedule.weekdays.forEach(weekday => {
    weekdays.push(weekday.day);
  });

  let scheduleTime = new job.RecurrenceRule();
  scheduleTime = {
    hour: new job.Range(Number(start[0]), Number(end[0])),
    minute: new job.Range(Number(start[1]), Number(end[1])),
    second: new job.Range(0, 59, 20),
    dayOfWeek: weekdays
  };
  // console.log("******* INTERVAL: ", scheduleTime);

  let outputs = await ruleDAO.listRuleById({ ruleId: rule.ruleId });

  await schedules.push(
    new job.scheduleJob(scheduleTime, async function() {
      if (outputs.isActive) {
        let execute = ruleProcessor.executeOutputs(outputs);
      }
    })
  );
}
